--TEST--
GH-16450 (PDO_ODBC can inject garbage into field values)
--EXTENSIONS--
pdo_odbc
--SKIPIF--
<?php
$dbpath = __DIR__ . "/test.mdb";
try {
    new PDO("odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};Dbq=$dbpath;Uid=Admin;Pwd=;");
} catch (PDOException $ex) {
    die("skip Cannot connect to MS Access database");
}
?>
--FILE--
<?php
$dbpath = __DIR__ . "/test.mdb";
$pdo = new PDO("odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};Dbq=$dbpath;Uid=Admin;Pwd=;");

$pdo->exec("CREATE TABLE gh16450 (Id INT, MyLongText LONGCHAR)");
$pdo->exec(sprintf("INSERT INTO gh16450 VALUES (1, '%s')", str_repeat("_", 2048)));
$pdo->exec(sprintf("INSERT INTO gh16450 VALUES (1, '%s')", str_repeat("_", 2049)));

$stmt = $pdo->query("SELECT MyLongText FROM gh16450");
var_dump($stmt->fetchColumn(0));
var_dump($stmt->fetchColumn(0));
?>
--CLEAN--
<?php
$dbpath = __DIR__ . "/test.mdb";
$pdo = new PDO("odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};Dbq=$dbpath;Uid=Admin;Pwd=;");
$pdo->exec("DROP TABLE gh16450");
?>
--EXPECT--
string(2048) "________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________"
string(2049) "_________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________"
